require( "scripts/tutorialdefines.lua" );

--[[ Default tutorial action format is as follows:
	{
		action = eTutorial_Wait, 
		actionID = -1, 
		mX = -1, 
		mY = -1, 
		arrow1X = -1, 
		arrow1Y = -1, 
		arrow1Rot = -1, 
		arrow2X = -1, 
		arrow2Y = -1, 
		arrow2Rot = -1, 
		arrow3X = -1,
		arrow3Y = -1,
		arrow3Rot = -1, 
		textName = "", 
		finished = false, 
		gameMode = 0
	},
]]--


kTopCenterBoxX = 480;
kTopCenterBoxY = 110;

kTopLeftBoxX = 200;
kTopLeftBoxY = 160;

kLineX = 65;
kLineY = 340;

kLine2X = 65;
kLine2Y = 300;

kTable1X = 590;
kTable1Y = 260;

kTable2X = 280;
kTable2Y = 370;

kTicketX = 210;
kTicketY = 40;

kFoodX = 170;
kFoodY = 40;

kDishCartX = 710;
kDishCartY = 410;

kUpgradeButtonX = 400;
kUpgradeButtonY = 490;

kEndlessLivesX = 600;
kEndlessLivesY = 490;


tutorial = 
{
	{
		action = eTutorial_Wait, 
	},
	
	{
		action = eTutorial_PickupCustomers, 
		mX = kTopCenterBoxX, 
		mY = kTopCenterBoxY, 
		arrow1X = kLineX, 
		arrow1Y = kLineY, 
		arrow1Rot = kArrowDown, 
		arrow2X = kTable1X, 
		arrow2Y = kTable1Y, 
		arrow2Rot = kArrowDown, 
		textName = "tutorial_0", 
	},
	
	{
		action = eTutorial_DropCustomers, 
		actionID = 1, 
		mX = kTopCenterBoxX, 
		mY = kTopCenterBoxY, 
		arrow1X = kTable1X, 
		arrow1Y = kTable1Y, 
		arrow1Rot = kArrowDown, 
		textName = "tutorial_1", 
	},
	
	{
		action = eTutorial_WaitForOrder, 
		actionID = 1, 
		mX = kTopCenterBoxX, 
		mY = kTopCenterBoxY, 
		textName = "tutorial_2", 
	},
	
	{
		action = eTutorial_TakeOrder, 
		actionID = 1, 
		mX = kTopCenterBoxX, 
		mY = kTopCenterBoxY, 
		arrow1X = kTable1X, 
		arrow1Y = kTable1Y, 
		arrow1Rot = kArrowDown,  
		textName = "tutorial_3", 
	},
	
	{
		action = eTutorial_DropTicket, 
		mX = kTopCenterBoxX, 
		mY = kTopCenterBoxY, 
		arrow1X = kTicketX, 
		arrow1Y = kTicketY, 
		arrow1Rot = kArrowDown, 
		textName = "tutorial_4", 
	},
	
	{
		action = eTutorial_WaitForChef, 
		mX = kTopCenterBoxX, 
		mY = kTopCenterBoxY, 
		textName = "tutorial_5", 
	},
	
	{
		action = eTutorial_PickupFood, 
		actionID = 1, 
		mX = kTopCenterBoxX, 
		mY = kTopCenterBoxY, 
		arrow1X = kFoodX, 
		arrow1Y = kFoodY, 
		arrow1Rot = kArrowDown,
		textName = "tutorial_6", 
	},
	
	{
		action = eTutorial_DropFood, 
		actionID = 1, 
		mX = kTopCenterBoxX, 
		mY = kTopCenterBoxY, 
		arrow1X = kTable1X, 
		arrow1Y = kTable1Y, 
		arrow1Rot = kArrowDown, 
		textName = "tutorial_7", 
	},
	
	{
		action = eTutorial_WaitForEat, 
		actionID = 1, 
		mX = kTopCenterBoxX, 
		mY = kTopCenterBoxY, 
		textName = "tutorial_8", 
	},
	
	{
		action = eTutorial_DropCheck, 
		actionID = 1, 
		mX = kTopCenterBoxX, 
		mY = kTopCenterBoxY, 
		arrow1X = kTable1X, 
		arrow1Y = kTable1Y, 
		arrow1Rot = kArrowDown, 
		textName = "tutorial_9", 
	},
	
	{
		action = eTutorial_UpgradeButton, 
		mX = kTopCenterBoxX, 
		mY = kTopCenterBoxY, 
		arrow1X = kUpgradeButtonX, 
		arrow1Y = kUpgradeButtonY, 
		arrow1Rot = kArrowDown, 
		textName = "tutorial_upgradebutton", 
		gameMode = 2
	},
	
	{
		action = eTutorial_WaitTime, 
		mX = kTopCenterBoxX, 
		mY = kTopCenterBoxY, 
		textName = "tutorial_10", 
		gameMode = 1
	},
	
	{
		action = eTutorial_WaitTime, 
		mX = kTopCenterBoxX, 
		mY = kTopCenterBoxY, 
		textName = "tutorial_10a", 
		gameMode = 2
	},
	
	{
		action = eTutorial_WaitForLeave, 
		actionID = 1, 
		mX = kTopCenterBoxX, 
		mY = kTopCenterBoxY, 
		textName = "tutorial_10", 
	},
	
	{
		action = eTutorial_PickupPlates, 
		actionID = 1, 
		mX = kTopCenterBoxX, 
		mY = kTopCenterBoxY, 
		arrow1X = kTable1X, 
		arrow1Y = kTable1Y, 
		arrow1Rot = kArrowDown, 
		textName = "tutorial_11", 
	},
	
	{
		action = eTutorial_DropPlates, 
		mX = kTopCenterBoxX, 
		mY = kTopCenterBoxY, 
		arrow1X = kDishCartX, 
		arrow1Y = kDishCartY, 
		arrow1Rot = kArrowRight, 
		textName = "tutorial_12", 
	},
	
	{
		action = eTutorial_Wait, 
	},
	
	{
		action = eTutorial_PickupCustomers, 
		mX = kTopCenterBoxX, 
		mY = kTopCenterBoxY, 
		arrow1X = 65, 
		arrow1Y = 300, 
		arrow1Rot = 0, 
		textName = "tutorial_14", 
	},
	
	{
		action = eTutorial_DropCustomers, 
		actionID = 1,
		mX = kTopCenterBoxX, 
		mY = kTopCenterBoxY, 
		arrow1X = kTable1X, 
		arrow1Y = kTable1Y, 
		arrow1Rot = kArrowDown,
		textName = "tutorial_13", 
	},
	
	{
		action = eTutorial_PickupCustomers, 
		mX = kTopCenterBoxX, 
		mY = kTopCenterBoxY, 
		arrow1X = kLine2X, 
		arrow1Y = kLine2Y, 
		arrow1Rot = 0, 
		textName = "tutorial_14_a", 
	},
	
	{
		action = eTutorial_DropCustomers, 
		actionID = 2,
		mX = kTopCenterBoxX, 
		mY = kTopCenterBoxY,
		arrow1X = kTable2X, 
		arrow1Y = kTable2Y,  
		arrow1Rot = kArrowDown,
		textName = "tutorial_13", 
	},
	
	{
		action = eTutorial_WaitForOrder, 
		actionID = 1, 
		mX = kTopCenterBoxX, 
		mY = kTopCenterBoxY, 
		textName = "tutorial_2", 
	},
	
	{
		action = eTutorial_WaitForOrder, 
		actionID = 2, 
		mX = kTopCenterBoxX, 
		mY = kTopCenterBoxY, 
		textName = "tutorial_2", 
	},
	
	{
		action = eTutorial_TakeOrder, 
		actionID = 1, 
		mX = kTopCenterBoxX, 
		mY = kTopCenterBoxY, 
		arrow1X = kTable1X, 
		arrow1Y = kTable1Y, 
		arrow1Rot = kArrowDown, 
		arrow2X = kTicketX, 
		arrow2Y = kTicketY, 
		arrow2Rot = kArrowDown, 
		textName = "tutorial_15", 
	},
	
	{
		action = eTutorial_TakeOrder, 
		actionID = 2, 
		mX = kTopCenterBoxX, 
		mY = kTopCenterBoxY, 
		arrow1X = kTable2X, 
		arrow1Y = kTable2Y, 
		arrow1Rot = kArrowDown,  
		arrow2X = kTicketX, 
		arrow2Y = kTicketY, 
		arrow2Rot = kArrowDown, 
		textName = "tutorial_16", 
	},
	
	{
		action = eTutorial_DropTicket, 
		mX = kTopCenterBoxX, 
		mY = kTopCenterBoxY, 
		arrow1X = kTicketX, 
		arrow1Y = kTicketY, 
		arrow1Rot = kArrowDown, 		
		textName = "tutorial_16", 
	},
	
	{
		action = eTutorial_DropTicket, 
		mX = kTopCenterBoxX, 
		mY = kTopCenterBoxY, 
		arrow1X = kTicketX, 
		arrow1Y = kTicketY, 
		arrow1Rot = kArrowDown, 		
		textName = "tutorial_16", 
	},
	{
		action = eTutorial_WaitForChef, 
		actionID = 1, 
		mX = kTopCenterBoxX, 
		mY = kTopCenterBoxY, 
		textName = "tutorial_17", 
	},
	{
		action = eTutorial_WaitForChef, 
		actionID = 2, 
		mX = kTopCenterBoxX, 
		mY = kTopCenterBoxY, 
		textName = "tutorial_17", 
	},
	
	{
		action = eTutorial_PickupFood, 
		actionID = 1,
		mX = kTopCenterBoxX, 
		mY = kTopCenterBoxY, 
		arrow1X = kFoodX, 
		arrow1Y = kFoodY, 
		arrow1Rot = kArrowDown, 
		textName = "tutorial_18", 
	},
	
	{
		action = eTutorial_PickupFood, 
		actionID = 2,
		mX = kTopCenterBoxX, 
		mY = kTopCenterBoxY, 
		arrow1X = kFoodX, 
		arrow1Y = kFoodY, 
		arrow1Rot = kArrowDown, 
		textName = "tutorial_18", 
	},
	
	{
		action = eTutorial_DropFood, 
		actionID = -1,
		mX = kTopCenterBoxX, 
		mY = kTopCenterBoxY, 
		arrow1X = kTable1X, 
		arrow1Y = kTable1Y, 
		arrow1Rot = kArrowDown, 
		arrow2X = kTable2X, 
		arrow2Y = kTable2Y, 
		arrow2Rot = kArrowDown, 
		textName = "tutorial_19", 
	},
	
	{
		action = eTutorial_DropFood, 
		actionID = -1,
		mX = kTopCenterBoxX, 
		mY = kTopCenterBoxY, 
		arrow1X = kTable1X, 
		arrow1Y = kTable1Y, 
		arrow1Rot = kArrowDown, 
		arrow2X = kTable2X, 
		arrow2Y = kTable2Y, 
		arrow2Rot = kArrowDown, 
		textName = "tutorial_19", 
	},
	
	{
		action = eTutorial_WaitForEat, 
		actionID = 1,
		mX = kTopCenterBoxX, 
		mY = kTopLeftBoxY, 
		textName = "tutorial_20", 
	},
	
	{
		action = eTutorial_WaitForEat, 
		actionID = 2,
		mX = kTopCenterBoxX, 
		mY = kTopCenterBoxY,  
		textName = "tutorial_20", 
	},
	
	{
		action = eTutorial_DropCheck, 
		actionID = -1,
		mX = kTopCenterBoxX, 
		mY = kTopCenterBoxY, 
		arrow1X = kTable1X, 
		arrow1Y = kTable1Y, 
		arrow1Rot = kArrowDown, 
		arrow2X = kTable2X, 
		arrow2Y = kTable2Y, 
		arrow2Rot = kArrowDown, 
		textName = "tutorial_21", 
	},
	
	{
		action = eTutorial_DropCheck, 
		actionID = -1,
		mX = kTopCenterBoxX, 
		mY = kTopCenterBoxY, 
		arrow1X = kTable1X, 
		arrow1Y = kTable1Y, 
		arrow1Rot = kArrowDown, 
		arrow2X = kTable2X, 
		arrow2Y = kTable2Y, 
		arrow2Rot = kArrowDown, 
		textName = "tutorial_21", 
	},
	
	{
		action = eTutorial_PickupPlates, 
		actionID = -1,
		mX = kTopCenterBoxX, 
		mY = kTopCenterBoxY, 
		arrow1X = kTable1X, 
		arrow1Y = kTable1Y, 
		arrow1Rot = kArrowDown, 
		arrow2X = kTable2X, 
		arrow2Y = kTable2Y, 
		arrow2Rot = kArrowDown,  
		arrow3X = kDishCartX,
		arrow3Y = kDishCartY,
		arrow3Rot = kArrowRight, 
		textName = "tutorial_22", 
	},
	
	{
		action = eTutorial_PickupPlates, 
		actionID = -1,
		mX = kTopCenterBoxX, 
		mY = kTopCenterBoxY, 
		arrow1X = kTable1X, 
		arrow1Y = kTable1Y, 
		arrow1Rot = kArrowDown, 
		arrow2X = kTable2X, 
		arrow2Y = kTable2Y, 
		arrow2Rot = kArrowDown,  
		arrow3X = kDishCartX,
		arrow3Y = kDishCartY,
		arrow3Rot = kArrowRight, 
		textName = "tutorial_22", 
	},
	
	{
		action = eTutorial_DropPlates, 
		mX = kTopCenterBoxX, 
		mY = kTopCenterBoxY, 
		arrow1X = kTable1X, 
		arrow1Y = kTable1Y, 
		arrow1Rot = kArrowDown, 
		arrow2X = kTable2X, 
		arrow2Y = kTable2Y, 
		arrow2Rot = kArrowDown,  
		arrow3X = kDishCartX,
		arrow3Y = kDishCartY,
		arrow3Rot = kArrowRight, 
		textName = "tutorial_22", 
	},
	
	{
		action = eTutorial_DropPlates, 
		mX = kTopCenterBoxX, 
		mY = kTopCenterBoxY, 
		arrow1X = kTable1X, 
		arrow1Y = kTable1Y, 
		arrow1Rot = kArrowDown, 
		arrow2X = kTable2X, 
		arrow2Y = kTable2Y, 
		arrow2Rot = kArrowDown,  
		arrow3X = kDishCartX,
		arrow3Y = kDishCartY,
		arrow3Rot = kArrowRight, 
		textName = "tutorial_22", 
	},
	
	{
		action = eTutorial_WaitTime, 
		mX = kTopCenterBoxX, 
		mY = kTopCenterBoxY, 
		textName = "tutorial_23", 
		gameMode = 1
	},
	
	{
		action = eTutorial_WaitTimeLonger, 
		mX = kTopCenterBoxX, 
		mY = kTopCenterBoxY, 
		arrow1X = kEndlessLivesX, 
		arrow1Y = kEndlessLivesY, 
		arrow1Rot = kArrowDown, 
		textName = "tutorial_endless_lives", 
		gameMode = 2
	},
	
	{
		action = eTutorial_WaitTimeLonger, 
		mX = kTopCenterBoxX, 
		mY = kTopCenterBoxY, 
		textName = "tutorial_endless_end", 
		gameMode = 2
	},
};